using System;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Text;
using gov.va.med.vbecs.Common;
namespace gov.va.med.vbecs.DAL.VAL.RPC
{	
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Stas Antropov</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>2/27/2005</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///		This class is used by the VBECS RPCs called by the VistALink Windows Service 
	///		TCP/IP Listener to obtain xml data from the VBECS database.
	///	</summary>

	#endregion

	public class RpcDataReader
	{
		internal static string workStationID = Environment.MachineName;
        internal static string dbConnectionString = "workstation id=" + workStationID + ";" + VbecsConfig.Current.PrimaryDbConnectionString;

		///<Developers>
		///	<Developer>Brian Tomlin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="982"> 
		///		<ExpectedInput>SprocName, parameter array.</ExpectedInput>
		///		<ExpectedOutput>Non-empty well-formed XML string.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="983"> 
		///		<ExpectedInput>Null instead of sproc name.</ExpectedInput>
		///		<ExpectedOutput>ArgumentNullException.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6759"> 
		///		<ExpectedInput>Valid sproc name, invalid set of parameters.</ExpectedInput>
		///		<ExpectedOutput>SqlException.</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Calls the supplied stored procedure and returns its XML output.
		/// </summary>
		/// <param name="sprocName">Stored procedure name.</param>
		/// <param name="parameters">Stored procedure parameters array.</param>
		/// <returns>XML result of the stored procedure call.</returns>
		public static string GetXmlData( string sprocName, params SqlParameter[] parameters )
		{
			if( sprocName == null )
				throw( new ArgumentNullException( "sprocName" ) );

			SqlCommand command = new SqlCommand(sprocName);
			command.CommandType = CommandType.StoredProcedure;
			command.Parameters.Clear();

			foreach (SqlParameter parameter in parameters) 
			{
				if (parameter.Value != null)
				{
					command.Parameters.Add(parameter);
				}
			}
			return RpcDataReader.GetData(command);
		}

		///<Developers>
		///	<Developer>Brian Tomlin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="985"> 
		///		<ExpectedInput>Valid sproc name.</ExpectedInput>
		///		<ExpectedOutput>Non-empty well-formed XML string.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1327"> 
		///		<ExpectedInput>Null instead of sproc name.</ExpectedInput>
		///		<ExpectedOutput>ArgumentNullException.</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Calls the supplied stored procedure and returns its XML output.
		/// </summary>
		/// <param name="sprocName">Stored procedure name.</param>
		/// <returns>XML result of the stored procedure call.</returns>
		public static string GetXmlData( string sprocName )
		{
			if( sprocName == null )
				throw( new ArgumentNullException( "sprocName" ) );

			SqlCommand command = new SqlCommand( sprocName );
			command.CommandType = CommandType.StoredProcedure;
			return RpcDataReader.GetData(command);
		}

		///<Developers>
		///	<Developer>Brian Tomlin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2004</CreationDate>
		/// <summary>
		/// Executes supplied <see cref="SqlCommand"/> and returns string (XML)
		/// data returned by the stored procedure.
		/// </summary>
		/// <param name="command"><see cref="SqlCommand"/> to execute (invokes appropriate stored procedure).</param>
		/// <returns>XML result of the stored procedure call.</returns>
		private static string GetData(SqlCommand command)
		{
            using (SqlConnection conn = new SqlConnection(DBConnectionString))
			{
				command.Connection = conn;
				command.Connection.Open();
				
				SqlDataReader reader;
				StringBuilder sb = new StringBuilder();
				reader = command.ExecuteReader();
				while (reader.Read())
				{
					sb.Append(reader.GetValue(0));
				}
				reader.Close();
				command.Connection.Close();
				return sb.ToString();
			}
		}

		/// <summary>
		/// Get/Set property to read/modify the database connection string.
		/// </summary>
		internal static string DBConnectionString
		{
			get
			{
				return dbConnectionString;
			}
			set
			{
				dbConnectionString = value;
			}
		}
	}
}
